<?php
require_once( __DIR__ . '/controls-manager.php' );

class PAFE_Column_Link extends \Elementor\Widget_Base {

	public function __construct() {
		parent::__construct();
		$this->init_control();
	}

	public function get_name() {
		return 'pafe-column-link';
	}

	public function pafe_register_controls( $element, $section_id ) {

		$element->start_controls_section(
			'pafe_column_link_section',
			[
				'label' => __( 'PAFE Column Link', 'pafe' ),
				'tab' => PAFE_Controls_Manager::TAB_PAFE,
			]
		);
		
		$element->add_control(
			'pafe_column_link',
			[
				'label' => __( 'Link', 'pafe' ),
				'type' => \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
                'render_type' => 'none',
				'description' => __( 'Note that it is not visible in edit/preview mode & can only be viewed on the frontend.', 'pafe' ),
				'label_block' => true,
			]
		);

        $element->add_control(
			'pafe_column_link_display',
			[
				'label' => esc_html__( 'Display', 'pafe' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__( 'Block', 'pafe' ),
					'flex' => esc_html__( 'Flex', 'pafe' ),
					'inline-block'  => esc_html__( 'Inline Block', 'pafe' ),
					'inline-flex' => esc_html__( 'Inline Flex', 'pafe' ),
					'inline' => esc_html__( 'Inline', 'pafe' ),
				]
			]
		);

		$element->end_controls_section();

	}

	public function before_render_section($element) {
		$settings = $element->get_settings_for_display();
		$link = $settings['pafe_column_link'];
		if( !empty($link['url']) ) { 
			$element->add_render_attribute( '_wrapper', [
				'data-pafe-section-link' => esc_url($link['url']),
				'data-pafe-section-link-external' => esc_attr($link['is_external']),
                'data-pafe-section-link-display' => esc_attr($settings['pafe_column_link_display']),
			] );
		}
	}

	protected function init_control() {
		add_action( 'elementor/element/column/layout/after_section_end', [ $this, 'pafe_register_controls' ], 10, 2 );
		add_action( 'elementor/frontend/column/before_render', [ $this, 'before_render_section'], 10, 1 );
		add_action( 'elementor/element/container/pafe_support_section/after_section_end', [ $this, 'pafe_register_controls' ], 10, 2 );
		add_action( 'elementor/frontend/container/before_render', [ $this, 'before_render_section'], 10, 1 );
	}

}
